% Simulation of Ramsey Model using Relaxation algorithm.
% By Niklas Brnager

clear all

globalpar                           % Initializes global parameters
parini                              % Load the parameter values
relaxsetting                        % Load the settings

[guess, start, errorcode] = initrelax(@funcODE, @funcSTAT, n, n1, n3, nu, y, M, statev);       

if errorcode==0
    
    [t, x]=relax(@funcODE, @funcSTAT, @funcINI, @funcfinal, n, n1, n3, nu, guess, M, start, Endcond, maxit, tol, damp, dampfac);    
    
    for i=1:M
        x(normal,i)=x(normal,i)./x(normal,end);
    end;
    
    varex;                              % Extracts the variables
 
    [EVa EVe Jac]=eigDAS(@funcODE, @funcSTAT, x(:,end));
    disp(['Eigenvalues: ',num2str(EVa')]);disp([' ']);
    
end